/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.deploy.engineyard.ui.wizard;

import com.aptana.deploy.engineyard.EngineYardPlugin;
import com.aptana.deploy.engineyard.ui.wizard.Messages;
import com.aptana.ui.util.SWTUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EngineYardSignupPage
extends WizardPage {
    public static final String NAME = "EngineYardSignup";
    private static final String ENGINE_YARD_ICON = "icons/ey_small_wizard.png";
    private Text userId;
    private String startingUserId;

    protected EngineYardSignupPage(String startingUserId) {
        super(NAME, Messages.EngineYardSignupPage_Title, EngineYardPlugin.getImageDescriptor(ENGINE_YARD_ICON));
        this.startingUserId = startingUserId;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.setControl((Control)composite);
        this.initializeDialogUnits((Control)parent);
        Label label = new Label(composite, 0);
        label.setText(Messages.EngineYardSignupPage_EnterCredentialsLabel);
        Composite credentials = new Composite(composite, 0);
        credentials.setLayout((Layout)new GridLayout(2, false));
        Label userIdLabel = new Label(credentials, 0);
        userIdLabel.setText(Messages.EngineYardSignupPage_EmailAddressLabel);
        this.userId = new Text(credentials, 2052);
        this.userId.setMessage(Messages.EngineYardSignupPage_EmailAddressExample);
        if (this.startingUserId != null && this.startingUserId.trim().length() > 0) {
            this.userId.setText(this.startingUserId);
        }
        GridData gd = new GridData(300, -1);
        this.userId.setLayoutData((Object)gd);
        Label note = new Label(composite, 64);
        Font dialogFont = JFaceResources.getDialogFont();
        FontData[] data = SWTUtils.italicizedFont((Font)JFaceResources.getDialogFont());
        final Font italic = new Font(dialogFont.getDevice(), data);
        note.setFont(italic);
        note.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!italic.isDisposed()) {
                    italic.dispose();
                }
            }
        });
        gd = new GridData(400, -1);
        note.setLayoutData((Object)gd);
        note.setText(Messages.EngineYardSignupPage_SignupNote);
        Button signup = new Button(composite, 8);
        signup.setText(Messages.EngineYardSignupPage_SignupButtonLabel);
        signup.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EngineYardSignupPage.this.isEmailValid(EngineYardSignupPage.this.userId.getText()).booleanValue()) {
                    MessageDialog.openError((Shell)EngineYardSignupPage.this.getShell(), (String)"Error", (String)Messages.EngineYardSignupPage_InvalidEmail_Message);
                    return;
                }
                if (EngineYardSignupPage.this.getWizard().performFinish()) {
                    ((WizardDialog)EngineYardSignupPage.this.getContainer()).close();
                }
            }
        });
        Dialog.applyDialogFont((Control)composite);
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public String getUserID() {
        return this.userId.getText();
    }

    public boolean isPageComplete() {
        String userId = this.userId.getText();
        if (userId == null || userId.trim().length() < 1) {
            this.setErrorMessage(Messages.EngineYardSignupPage_EmptyEmailAddressLabel);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private Boolean isEmailValid(String email) {
        Pattern p = Pattern.compile("^[\\w\\.-]+@([\\w\\-]+\\.)+[A-Z]{2,4}$", 2);
        Matcher m = p.matcher(email);
        if (m.matches()) {
            return true;
        }
        return false;
    }
}

